import math
def odredi_stranice_pravougaonika(P, O):
    """
    Izracunava stranice pravougaonika na osnovu date površine i obima.
    
    Vraca tuple (stranica_a, stranica_b) ili None ako rešenje ne postoji.
    """
    A = 1
    B = -(O / 2)
    C = P
    diskriminanta = B**2 - 4*A*C
    if diskriminanta < 0:
        print("Nije moguce pronaci realne stranice za date vrednosti (rešenje je kompleksno).")
        return None
    elif diskriminanta == 0:
        a = -B / (2 * A)
        b = a
        return (a, b)
    else:
        a1 = (-B + math.sqrt(diskriminanta)) / (2 * A)
        a2 = (-B - math.sqrt(diskriminanta)) / (2 * A)
        return (a1, a2)
P=float(input("Kolika je površina pravougaonika"))
O=float(input("Koliki je obim pravougaonika"))
rezultat = odredi_stranice_pravougaonika(P, O)
if rezultat:
    stranica_a, stranica_b = rezultat
    print(f"Stranica a = {stranica_a}")
    print(f"Stranica b = {stranica_b}")